/* SPDX-License-Identifier: GPL-2.0 */
#define PINMUX_PIN(no, func, ioset) \
(((no) & 0xffff) | (((func) & 0xf) << 16) | (((ioset) & 0xff) << 20))

#define PIN_PA0				0
#define PIN_PA0__GPIO			PINMUX_PIN(PIN_PA0, 0, 0)
#define PIN_PA0__SDMMC0_CK		PINMUX_PIN(PIN_PA0, 1, 1)
#define PIN_PA0__FLEXCOM0_IO0		PINMUX_PIN(PIN_PA0, 2, 1)
#define PIN_PA0__CANTX3			PINMUX_PIN(PIN_PA0, 3, 1)
#define PIN_PA0__PWML0			PINMUX_PIN(PIN_PA0, 5, 2)
#define PIN_PA1				1
#define PIN_PA1__GPIO			PINMUX_PIN(PIN_PA1, 0, 0)
#define PIN_PA1__SDMMC0_CMD		PINMUX_PIN(PIN_PA1, 1, 1)
#define PIN_PA1__FLEXCOM0_IO1		PINMUX_PIN(PIN_PA1, 2, 1)
#define PIN_PA1__CANRX3			PINMUX_PIN(PIN_PA1, 3, 1)
#define PIN_PA1__D14			PINMUX_PIN(PIN_PA1, 4, 1)
#define PIN_PA1__PWMH0			PINMUX_PIN(PIN_PA1, 5, 3)
#define PIN_PA2				2
#define PIN_PA2__GPIO			PINMUX_PIN(PIN_PA2, 0, 0)
#define PIN_PA2__SDMMC0_RSTN		PINMUX_PIN(PIN_PA2, 1, 1)
#define PIN_PA2__FLEXCOM0_IO2		PINMUX_PIN(PIN_PA2, 2, 1)
#define PIN_PA2__PDMC1_CLK		PINMUX_PIN(PIN_PA2, 3, 1)
#define PIN_PA2__D15			PINMUX_PIN(PIN_PA2, 4, 1)
#define PIN_PA2__PWMH1			PINMUX_PIN(PIN_PA2, 5, 3)
#define PIN_PA2__FLEXCOM1_IO0		PINMUX_PIN(PIN_PA2, 6, 3)
#define PIN_PA3				3
#define PIN_PA3__GPIO			PINMUX_PIN(PIN_PA3, 0, 0)
#define PIN_PA3__SDMMC0_DAT0		PINMUX_PIN(PIN_PA3, 1, 1)
#define PIN_PA3__FLEXCOM0_IO3		PINMUX_PIN(PIN_PA3, 2, 1)
#define PIN_PA3__PDMC1_DS0		PINMUX_PIN(PIN_PA3, 3, 1)
#define PIN_PA3__NWR1_NBS1		PINMUX_PIN(PIN_PA3, 4, 1)
#define PIN_PA3__PWML3			PINMUX_PIN(PIN_PA3, 5, 3)
#define PIN_PA3__FLEXCOM1_IO1		PINMUX_PIN(PIN_PA3, 6, 3)
#define PIN_PA4				4
#define PIN_PA4__GPIO			PINMUX_PIN(PIN_PA4, 0, 0)
#define PIN_PA4__SDMMC0_DAT1		PINMUX_PIN(PIN_PA4, 1, 1)
#define PIN_PA4__FLEXCOM0_IO4		PINMUX_PIN(PIN_PA4, 2, 1)
#define PIN_PA4__PDMC1_DS1		PINMUX_PIN(PIN_PA4, 3, 1)
#define PIN_PA4__NCS2			PINMUX_PIN(PIN_PA4, 4, 1)
#define PIN_PA4__PWMH3			PINMUX_PIN(PIN_PA4, 5, 3)
#define PIN_PA4__FLEXCOM2_IO0		PINMUX_PIN(PIN_PA4, 6, 3)
#define PIN_PA5				5
#define PIN_PA5__GPIO			PINMUX_PIN(PIN_PA5, 0, 0)
#define PIN_PA5__SDMMC0_DAT2		PINMUX_PIN(PIN_PA5, 1, 1)
#define PIN_PA5__FLEXCOM1_IO0		PINMUX_PIN(PIN_PA5, 2, 1)
#define PIN_PA5__CANTX2			PINMUX_PIN(PIN_PA5, 3, 1)
#define PIN_PA5__A23			PINMUX_PIN(PIN_PA5, 4, 1)
#define PIN_PA5__PWMEXTRG0		PINMUX_PIN(PIN_PA5, 5, 3)
#define PIN_PA5__FLEXCOM2_IO1		PINMUX_PIN(PIN_PA5, 6, 3)
#define PIN_PA6				6
#define PIN_PA6__GPIO			PINMUX_PIN(PIN_PA6, 0, 0)
#define PIN_PA6__SDMMC0_DAT3		PINMUX_PIN(PIN_PA6, 1, 1)
#define PIN_PA6__FLEXCOM1_IO1		PINMUX_PIN(PIN_PA6, 2, 1)
#define PIN_PA6__CANRX2			PINMUX_PIN(PIN_PA6, 3, 1)
#define PIN_PA6__A24			PINMUX_PIN(PIN_PA6, 4, 1)
#define PIN_PA6__PWMEXTRG1		PINMUX_PIN(PIN_PA6, 5, 3)
#define PIN_PA6__FLEXCOM3_IO0		PINMUX_PIN(PIN_PA6, 6, 3)
#define PIN_PA7				7
#define PIN_PA7__GPIO			PINMUX_PIN(PIN_PA7, 0, 0)
#define PIN_PA7__SDMMC0_DAT4		PINMUX_PIN(PIN_PA7, 1, 1)
#define PIN_PA7__FLEXCOM2_IO0		PINMUX_PIN(PIN_PA7, 2, 1)
#define PIN_PA7__CANTX1			PINMUX_PIN(PIN_PA7, 3, 1)
#define PIN_PA7__NWAIT			PINMUX_PIN(PIN_PA7, 4, 1)
#define PIN_PA7__PWMFI0			PINMUX_PIN(PIN_PA7, 5, 3)
#define PIN_PA7__FLEXCOM3_IO1		PINMUX_PIN(PIN_PA7, 6, 3)
#define PIN_PA8				8
#define PIN_PA8__GPIO			PINMUX_PIN(PIN_PA8, 0, 0)
#define PIN_PA8__SDMMC0_DAT5		PINMUX_PIN(PIN_PA8, 1, 1)
#define PIN_PA8__FLEXCOM2_IO1		PINMUX_PIN(PIN_PA8, 2, 1)
#define PIN_PA8__CANRX1			PINMUX_PIN(PIN_PA8, 3, 1)
#define PIN_PA8__NCS0			PINMUX_PIN(PIN_PA8, 4, 1)
#define PIN_PA8__PWMIF1			PINMUX_PIN(PIN_PA8, 5, 3)
#define PIN_PA8__FLEXCOM4_IO0		PINMUX_PIN(PIN_PA8, 6, 3)
#define PIN_PA9				9
#define PIN_PA9__GPIO			PINMUX_PIN(PIN_PA9, 0, 0)
#define PIN_PA9__SDMMC0_DAT6		PINMUX_PIN(PIN_PA9, 1, 1)
#define PIN_PA9__FLEXCOM2_IO2		PINMUX_PIN(PIN_PA9, 2, 1)
#define PIN_PA9__CANTX0			PINMUX_PIN(PIN_PA9, 3, 1)
#define PIN_PA9__SMCK			PINMUX_PIN(PIN_PA9, 4, 1)
#define PIN_PA9__SPDIF_RX		PINMUX_PIN(PIN_PA9, 5, 1)
#define PIN_PA9__FLEXCOM4_IO1		PINMUX_PIN(PIN_PA9, 6, 3)
#define PIN_PA10			10
#define PIN_PA10__GPIO			PINMUX_PIN(PIN_PA10, 0, 0)
#define PIN_PA10__SDMMC0_DAT7		PINMUX_PIN(PIN_PA10, 1, 1)
#define PIN_PA10__FLEXCOM2_IO3		PINMUX_PIN(PIN_PA10, 2, 1)
#define PIN_PA10__CANRX0		PINMUX_PIN(PIN_PA10, 3, 1)
#define PIN_PA10__NCS1			PINMUX_PIN(PIN_PA10, 4, 1)
#define PIN_PA10__SPDIF_TX		PINMUX_PIN(PIN_PA10, 5, 1)
#define PIN_PA10__FLEXCOM5_IO0		PINMUX_PIN(PIN_PA10, 6, 3)
#define PIN_PA11			11
#define PIN_PA11__GPIO			PINMUX_PIN(PIN_PA11, 0, 0)
#define PIN_PA11__SDMMC0_DS		PINMUX_PIN(PIN_PA11, 1, 1)
#define PIN_PA11__FLEXCOM2_IO4		PINMUX_PIN(PIN_PA11, 2, 1)
#define PIN_PA11__A0_NBS0		PINMUX_PIN(PIN_PA11, 4, 1)
#define PIN_PA11__TIOA0			PINMUX_PIN(PIN_PA11, 5, 1)
#define PIN_PA11__FLEXCOM5_IO1		PINMUX_PIN(PIN_PA11, 6, 3)
#define PIN_PA12			12
#define PIN_PA12__GPIO			PINMUX_PIN(PIN_PA12, 0, 0)
#define PIN_PA12__SDMMC0_WP		PINMUX_PIN(PIN_PA12, 1, 1)
#define PIN_PA12__FLEXCOM1_IO3		PINMUX_PIN(PIN_PA12, 2, 1)
#define PIN_PA12__FLEXCOM3_IO5		PINMUX_PIN(PIN_PA12, 4, 1)
#define PIN_PA12__PWML2			PINMUX_PIN(PIN_PA12, 5, 3)
#define PIN_PA12__FLEXCOM6_IO0		PINMUX_PIN(PIN_PA12, 6, 3)
#define PIN_PA13			13
#define PIN_PA13__GPIO			PINMUX_PIN(PIN_PA13, 0, 0)
#define PIN_PA13__SDMMC0_1V8SEL		PINMUX_PIN(PIN_PA13, 1, 1)
#define PIN_PA13__FLEXCOM1_IO2		PINMUX_PIN(PIN_PA13, 2, 1)
#define PIN_PA13__FLEXCOM3_IO6		PINMUX_PIN(PIN_PA13, 4, 1)
#define PIN_PA13__PWMH2			PINMUX_PIN(PIN_PA13, 5, 3)
#define PIN_PA13__FLEXCOM6_IO1		PINMUX_PIN(PIN_PA13, 6, 3)
#define PIN_PA14			14
#define PIN_PA14__GPIO			PINMUX_PIN(PIN_PA14, 0, 0)
#define PIN_PA14__SDMMC0_CD		PINMUX_PIN(PIN_PA14, 1, 1)
#define PIN_PA14__FLEXCOM1_IO4		PINMUX_PIN(PIN_PA14, 2, 1)
#define PIN_PA14__A25			PINMUX_PIN(PIN_PA14, 4, 1)
#define PIN_PA14__PWML1			PINMUX_PIN(PIN_PA14, 5, 3)
#define PIN_PA15			15
#define PIN_PA15__GPIO			PINMUX_PIN(PIN_PA15, 0, 0)
#define PIN_PA15__G0_TXEN		PINMUX_PIN(PIN_PA15, 1, 1)
#define PIN_PA15__FLEXCOM3_IO0		PINMUX_PIN(PIN_PA15, 2, 1)
#define PIN_PA15__ISC_MCK		PINMUX_PIN(PIN_PA15, 3, 1)
#define PIN_PA15__A1			PINMUX_PIN(PIN_PA15, 4, 1)
#define PIN_PA15__TIOB0			PINMUX_PIN(PIN_PA15, 5, 1)
#define PIN_PA16			16
#define PIN_PA16__GPIO			PINMUX_PIN(PIN_PA16, 0, 0)
#define PIN_PA16__G0_TX0		PINMUX_PIN(PIN_PA16, 1, 1)
#define PIN_PA16__FLEXCOM3_IO1		PINMUX_PIN(PIN_PA16, 2, 1)
#define PIN_PA16__ISC_D0		PINMUX_PIN(PIN_PA16, 3, 1)
#define PIN_PA16__A2			PINMUX_PIN(PIN_PA16, 4, 1)
#define PIN_PA16__TCLK0			PINMUX_PIN(PIN_PA16, 5, 1)
#define PIN_PA17			17
#define PIN_PA17__GPIO			PINMUX_PIN(PIN_PA17, 0, 0)
#define PIN_PA17__G0_TX1		PINMUX_PIN(PIN_PA17, 1, 1)
#define PIN_PA17__FLEXCOM3_IO2		PINMUX_PIN(PIN_PA17, 2, 1)
#define PIN_PA17__ISC_D1		PINMUX_PIN(PIN_PA17, 3, 1)
#define PIN_PA17__A3			PINMUX_PIN(PIN_PA17, 4, 1)
#define PIN_PA17__TIOA1			PINMUX_PIN(PIN_PA17, 5, 1)
#define PIN_PA18			18
#define PIN_PA18__GPIO			PINMUX_PIN(PIN_PA18, 0, 0)
#define PIN_PA18__G0_RXDV		PINMUX_PIN(PIN_PA18, 1, 1)
#define PIN_PA18__FLEXCOM3_IO3		PINMUX_PIN(PIN_PA18, 2, 1)
#define PIN_PA18__ISC_D2		PINMUX_PIN(PIN_PA18, 3, 1)
#define PIN_PA18__A4			PINMUX_PIN(PIN_PA18, 4, 1)
#define PIN_PA18__TIOB1			PINMUX_PIN(PIN_PA18, 5, 1)
#define PIN_PA19			19
#define PIN_PA19__GPIO			PINMUX_PIN(PIN_PA19, 0, 0)
#define PIN_PA19__G0_RX0		PINMUX_PIN(PIN_PA19, 1, 1)
#define PIN_PA19__FLEXCOM3_IO4		PINMUX_PIN(PIN_PA19, 2, 1)
#define PIN_PA19__ISC_D3		PINMUX_PIN(PIN_PA19, 3, 1)
#define PIN_PA19__A5			PINMUX_PIN(PIN_PA19, 4, 1)
#define PIN_PA19__TCLK1			PINMUX_PIN(PIN_PA19, 5, 1)
#define PIN_PA20			20
#define PIN_PA20__GPIO			PINMUX_PIN(PIN_PA20, 0, 0)
#define PIN_PA20__G0_RX1		PINMUX_PIN(PIN_PA20, 1, 1)
#define PIN_PA20__FLEXCOM4_IO0		PINMUX_PIN(PIN_PA20, 2, 1)
#define PIN_PA20__ISC_D4		PINMUX_PIN(PIN_PA20, 3, 1)
#define PIN_PA20__A6			PINMUX_PIN(PIN_PA20, 4, 1)
#define PIN_PA20__TIOA2			PINMUX_PIN(PIN_PA20, 5, 1)
#define PIN_PA21			21
#define PIN_PA21__GPIO			PINMUX_PIN(PIN_PA21, 0, 0)
#define PIN_PA21__G0_RXER		PINMUX_PIN(PIN_PA21, 1, 1)
#define PIN_PA21__FLEXCOM4_IO1		PINMUX_PIN(PIN_PA21, 2, 1)
#define PIN_PA21__ISC_D5		PINMUX_PIN(PIN_PA21, 3, 1)
#define PIN_PA21__A7			PINMUX_PIN(PIN_PA21, 4, 1)
#define PIN_PA21__TIOB2			PINMUX_PIN(PIN_PA21, 5, 1)
#define PIN_PA22			22
#define PIN_PA22__GPIO			PINMUX_PIN(PIN_PA22, 0, 0)
#define PIN_PA22__G0_MDC		PINMUX_PIN(PIN_PA22, 1, 1)
#define PIN_PA22__FLEXCOM4_IO2		PINMUX_PIN(PIN_PA22, 2, 1)
#define PIN_PA22__ISC_D6		PINMUX_PIN(PIN_PA22, 3, 1)
#define PIN_PA22__A8			PINMUX_PIN(PIN_PA22, 4, 1)
#define PIN_PA22__TCLK2			PINMUX_PIN(PIN_PA22, 5, 1)
#define PIN_PA23			23
#define PIN_PA23__GPIO			PINMUX_PIN(PIN_PA23, 0, 0)
#define PIN_PA23__G0_MDIO		PINMUX_PIN(PIN_PA23, 1, 1)
#define PIN_PA23__FLEXCOM4_IO3		PINMUX_PIN(PIN_PA23, 2, 1)
#define PIN_PA23__ISC_D7		PINMUX_PIN(PIN_PA23, 3, 1)
#define PIN_PA23__A9			PINMUX_PIN(PIN_PA23, 4, 1)
#define PIN_PA24			24
#define PIN_PA24__GPIO			PINMUX_PIN(PIN_PA24, 0, 0)
#define PIN_PA24__G0_TXCK		PINMUX_PIN(PIN_PA24, 1, 1)
#define PIN_PA24__FLEXCOM4_IO4		PINMUX_PIN(PIN_PA24, 2, 1)
#define PIN_PA24__ISC_HSYNC		PINMUX_PIN(PIN_PA24, 3, 1)
#define PIN_PA24__A10			PINMUX_PIN(PIN_PA24, 4, 1)
#define PIN_PA24__FLEXCOM0_IO5		PINMUX_PIN(PIN_PA24, 5, 1)
#define PIN_PA25			25
#define PIN_PA25__GPIO			PINMUX_PIN(PIN_PA25, 0, 0)
#define PIN_PA25__G0_125CK		PINMUX_PIN(PIN_PA25, 1, 1)
#define PIN_PA25__FLEXCOM5_IO4		PINMUX_PIN(PIN_PA25, 2, 1)
#define PIN_PA25__ISC_VSYNC		PINMUX_PIN(PIN_PA25, 3, 1)
#define PIN_PA25__A11			PINMUX_PIN(PIN_PA25, 4, 1)
#define PIN_PA25__FLEXCOM0_IO6		PINMUX_PIN(PIN_PA25, 5, 1)
#define PIN_PA25__FLEXCOM7_IO0		PINMUX_PIN(PIN_PA25, 6, 3)
#define PIN_PA26			26
#define PIN_PA26__GPIO			PINMUX_PIN(PIN_PA26, 0, 0)
#define PIN_PA26__G0_TX2		PINMUX_PIN(PIN_PA26, 1, 1)
#define PIN_PA26__FLEXCOM5_IO2		PINMUX_PIN(PIN_PA26, 2, 1)
#define PIN_PA26__ISC_FIELD		PINMUX_PIN(PIN_PA26, 3, 1)
#define PIN_PA26__A12			PINMUX_PIN(PIN_PA26, 4, 1)
#define PIN_PA26__TF0			PINMUX_PIN(PIN_PA26, 5, 1)
#define PIN_PA26__FLEXCOM7_IO1		PINMUX_PIN(PIN_PA26, 6, 3)
#define PIN_PA27			27
#define PIN_PA27__GPIO			PINMUX_PIN(PIN_PA27, 0, 0)
#define PIN_PA27__G0_TX3		PINMUX_PIN(PIN_PA27, 1, 1)
#define PIN_PA27__FLEXCOM5_IO3		PINMUX_PIN(PIN_PA27, 2, 1)
#define PIN_PA27__ISC_PCK		PINMUX_PIN(PIN_PA27, 3, 1)
#define PIN_PA27__A13			PINMUX_PIN(PIN_PA27, 4, 1)
#define PIN_PA27__TK0			PINMUX_PIN(PIN_PA27, 5, 1)
#define PIN_PA27__FLEXCOM8_IO0		PINMUX_PIN(PIN_PA27, 6, 3)
#define PIN_PA28			28
#define PIN_PA28__GPIO			PINMUX_PIN(PIN_PA28, 0, 0)
#define PIN_PA28__G0_RX2		PINMUX_PIN(PIN_PA28, 1, 1)
#define PIN_PA28__FLEXCOM5_IO0		PINMUX_PIN(PIN_PA28, 2, 1)
#define PIN_PA28__ISC_D8		PINMUX_PIN(PIN_PA28, 3, 1)
#define PIN_PA28__A14			PINMUX_PIN(PIN_PA28, 4, 1)
#define PIN_PA28__RD0			PINMUX_PIN(PIN_PA28, 5, 1)
#define PIN_PA28__FLEXCOM8_IO1		PINMUX_PIN(PIN_PA28, 6, 3)
#define PIN_PA29			29
#define PIN_PA29__GPIO			PINMUX_PIN(PIN_PA29, 0, 0)
#define PIN_PA29__G0_RX3		PINMUX_PIN(PIN_PA29, 1, 1)
#define PIN_PA29__FLEXCOM5_IO1		PINMUX_PIN(PIN_PA29, 2, 1)
#define PIN_PA29__ISC_D9		PINMUX_PIN(PIN_PA29, 3, 1)
#define PIN_PA29__A15			PINMUX_PIN(PIN_PA29, 4, 1)
#define PIN_PA29__RF0			PINMUX_PIN(PIN_PA29, 5, 1)
#define PIN_PA29__FLEXCOM9_IO0		PINMUX_PIN(PIN_PA29, 6, 3)
#define PIN_PA30			30
#define PIN_PA30__GPIO			PINMUX_PIN(PIN_PA30, 0, 0)
#define PIN_PA30__G0_RXCK		PINMUX_PIN(PIN_PA30, 1, 1)
#define PIN_PA30__FLEXCOM6_IO4		PINMUX_PIN(PIN_PA30, 2, 1)
#define PIN_PA30__ISC_D10		PINMUX_PIN(PIN_PA30, 3, 1)
#define PIN_PA30__A16			PINMUX_PIN(PIN_PA30, 4, 1)
#define PIN_PA30__RK0			PINMUX_PIN(PIN_PA30, 5, 1)
#define PIN_PA30__FLEXCOM9_IO1		PINMUX_PIN(PIN_PA30, 6, 3)
#define PIN_PA31			31
#define PIN_PA31__GPIO			PINMUX_PIN(PIN_PA31, 0, 0)
#define PIN_PA31__G0_TXER		PINMUX_PIN(PIN_PA31, 1, 1)
#define PIN_PA31__FLEXCOM6_IO2		PINMUX_PIN(PIN_PA31, 2, 1)
#define PIN_PA31__ISC_D11		PINMUX_PIN(PIN_PA31, 3, 1)
#define PIN_PA31__A17			PINMUX_PIN(PIN_PA31, 4, 1)
#define PIN_PA31__TD0			PINMUX_PIN(PIN_PA31, 5, 1)
#define PIN_PA31__FLEXCOM10_IO0		PINMUX_PIN(PIN_PA31, 6, 3)
#define PIN_PB0				32
#define PIN_PB0__GPIO			PINMUX_PIN(PIN_PB0, 0, 0)
#define PIN_PB0__G0_COL			PINMUX_PIN(PIN_PB0, 1, 1)
#define PIN_PB0__FLEXCOM6_IO3		PINMUX_PIN(PIN_PB0, 2, 2)
#define PIN_PB0__EXT_IRQ0		PINMUX_PIN(PIN_PB0, 3, 1)
#define PIN_PB0__A18			PINMUX_PIN(PIN_PB0, 4, 1)
#define PIN_PB0__SPDIF_RX		PINMUX_PIN(PIN_PB0, 5, 2)
#define PIN_PB0__FLEXCOM10_IO1		PINMUX_PIN(PIN_PB0, 6, 3)
#define PIN_PB1				33
#define PIN_PB1__GPIO			PINMUX_PIN(PIN_PB1, 0, 0)
#define PIN_PB1__G0_CRS			PINMUX_PIN(PIN_PB1, 1, 1)
#define PIN_PB1__FLEXCOM6_IO1		PINMUX_PIN(PIN_PB1, 2, 2)
#define PIN_PB1__EXT_IRQ1		PINMUX_PIN(PIN_PB1, 3, 1)
#define PIN_PB1__A19			PINMUX_PIN(PIN_PB1, 4, 1)
#define PIN_PB1__SPDIF_TX		PINMUX_PIN(PIN_PB1, 5, 2)
#define PIN_PB1__FLEXCOM11_IO0		PINMUX_PIN(PIN_PB1, 6, 3)
#define PIN_PB2				34
#define PIN_PB2__GPIO			PINMUX_PIN(PIN_PB2, 0, 0)
#define PIN_PB2__G0_TSUCOMP		PINMUX_PIN(PIN_PB2, 1, 1)
#define PIN_PB2__FLEXCOM6_IO0		PINMUX_PIN(PIN_PB2, 2, 1)
#define PIN_PB2__ADTRG			PINMUX_PIN(PIN_PB2, 3, 1)
#define PIN_PB2__A20			PINMUX_PIN(PIN_PB2, 4, 1)
#define PIN_PB2__FLEXCOM11_IO0		PINMUX_PIN(PIN_PB2, 6, 3)
#define PIN_PB3				35
#define PIN_PB3__GPIO			PINMUX_PIN(PIN_PB3, 0, 0)
#define PIN_PB3__RF1			PINMUX_PIN(PIN_PB3, 1, 1)
#define PIN_PB3__FLEXCOM11_IO0		PINMUX_PIN(PIN_PB3, 2, 1)
#define PIN_PB3__PCK2			PINMUX_PIN(PIN_PB3, 3, 2)
#define PIN_PB3__D8			PINMUX_PIN(PIN_PB3, 4, 1)
#define PIN_PB4				36
#define PIN_PB4__GPIO			PINMUX_PIN(PIN_PB4, 0, 0)
#define PIN_PB4__TF1			PINMUX_PIN(PIN_PB4, 1, 1)
#define PIN_PB4__FLEXCOM11_IO1		PINMUX_PIN(PIN_PB4, 2, 1)
#define PIN_PB4__PCK3			PINMUX_PIN(PIN_PB4, 3, 2)
#define PIN_PB4__D9			PINMUX_PIN(PIN_PB4, 4, 1)
#define PIN_PB5				37
#define PIN_PB5__GPIO			PINMUX_PIN(PIN_PB5, 0, 0)
#define PIN_PB5__TK1			PINMUX_PIN(PIN_PB5, 1, 1)
#define PIN_PB5__FLEXCOM11_IO2		PINMUX_PIN(PIN_PB5, 2, 1)
#define PIN_PB5__PCK4			PINMUX_PIN(PIN_PB5, 3, 2)
#define PIN_PB5__D10			PINMUX_PIN(PIN_PB5, 4, 1)
#define PIN_PB6				38
#define PIN_PB6__GPIO			PINMUX_PIN(PIN_PB6, 0, 0)
#define PIN_PB6__RK1			PINMUX_PIN(PIN_PB6, 1, 1)
#define PIN_PB6__FLEXCOM11_IO3		PINMUX_PIN(PIN_PB6, 2, 1)
#define PIN_PB6__PCK5			PINMUX_PIN(PIN_PB6, 3, 2)
#define PIN_PB6__D11			PINMUX_PIN(PIN_PB6, 4, 1)
#define PIN_PB7				39
#define PIN_PB7__GPIO			PINMUX_PIN(PIN_PB7, 0, 0)
#define PIN_PB7__TD1			PINMUX_PIN(PIN_PB7, 1, 1)
#define PIN_PB7__FLEXCOM11_IO4		PINMUX_PIN(PIN_PB7, 2, 1)
#define PIN_PB7__FLEXCOM3_IO5		PINMUX_PIN(PIN_PB7, 3, 2)
#define PIN_PB7__D12			PINMUX_PIN(PIN_PB7, 4, 1)
#define PIN_PB8				40
#define PIN_PB8__GPIO			PINMUX_PIN(PIN_PB8, 0, 0)
#define PIN_PB8__RD1			PINMUX_PIN(PIN_PB8, 1, 1)
#define PIN_PB8__FLEXCOM8_IO0		PINMUX_PIN(PIN_PB8, 2, 1)
#define PIN_PB8__FLEXCOM3_IO6		PINMUX_PIN(PIN_PB8, 3, 2)
#define PIN_PB8__D13			PINMUX_PIN(PIN_PB8, 4, 1)
#define PIN_PB9				41
#define PIN_PB9__GPIO			PINMUX_PIN(PIN_PB9, 0, 0)
#define PIN_PB9__QSPI0_IO3		PINMUX_PIN(PIN_PB9, 1, 1)
#define PIN_PB9__FLEXCOM8_IO1		PINMUX_PIN(PIN_PB9, 2, 1)
#define PIN_PB9__PDMC0_CLK		PINMUX_PIN(PIN_PB9, 3, 1)
#define PIN_PB9__NCS3_NANDCS		PINMUX_PIN(PIN_PB9, 4, 1)
#define PIN_PB9__PWML0			PINMUX_PIN(PIN_PB9, 5, 2)
#define PIN_PB10			42
#define PIN_PB10__GPIO			PINMUX_PIN(PIN_PB10, 0, 0)
#define PIN_PB10__QSPI0_IO2		PINMUX_PIN(PIN_PB10, 1, 1)
#define PIN_PB10__FLEXCOM8_IO2		PINMUX_PIN(PIN_PB10, 2, 1)
#define PIN_PB10__PDMC0_DS0		PINMUX_PIN(PIN_PB10, 3, 1)
#define PIN_PB10__NWE_NWR0_NANDWE	PINMUX_PIN(PIN_PB10, 4, 1)
#define PIN_PB10__PWMH0			PINMUX_PIN(PIN_PB10, 5, 2)
#define PIN_PB11			43
#define PIN_PB11__GPIO			PINMUX_PIN(PIN_PB11, 0, 0)
#define PIN_PB11__QSPI0_IO1		PINMUX_PIN(PIN_PB11, 1, 1)
#define PIN_PB11__FLEXCOM8_IO3		PINMUX_PIN(PIN_PB11, 2, 1)
#define PIN_PB11__PDMC0_DS1		PINMUX_PIN(PIN_PB11, 3, 1)
#define PIN_PB11__NRD_NANDOE		PINMUX_PIN(PIN_PB11, 4, 1)
#define PIN_PB11__PWML1			PINMUX_PIN(PIN_PB11, 5, 2)
#define PIN_PB12			44
#define PIN_PB12__GPIO			PINMUX_PIN(PIN_PB12, 0, 0)
#define PIN_PB12__QSPI0_IO0		PINMUX_PIN(PIN_PB12, 1, 1)
#define PIN_PB12__FLEXCOM8_IO4		PINMUX_PIN(PIN_PB12, 2, 1)
#define PIN_PB12__FLEXCOM6_IO5		PINMUX_PIN(PIN_PB12, 3, 1)
#define PIN_PB12__A21_NANDALE		PINMUX_PIN(PIN_PB12, 4, 1)
#define PIN_PB12__PWMH1			PINMUX_PIN(PIN_PB12, 5, 2)
#define PIN_PB13			45
#define PIN_PB13__GPIO			PINMUX_PIN(PIN_PB13, 0, 0)
#define PIN_PB13__QSPI0_CS		PINMUX_PIN(PIN_PB13, 1, 1)
#define PIN_PB13__FLEXCOM9_IO0		PINMUX_PIN(PIN_PB13, 2, 1)
#define PIN_PB13__FLEXCOM6_IO6		PINMUX_PIN(PIN_PB13, 3, 1)
#define PIN_PB13__A22_NANDCLE		PINMUX_PIN(PIN_PB13, 4, 1)
#define PIN_PB13__PWML2			PINMUX_PIN(PIN_PB13, 5, 2)
#define PIN_PB14			46
#define PIN_PB14__GPIO			PINMUX_PIN(PIN_PB14, 0, 0)
#define PIN_PB14__QSPI0_SCK		PINMUX_PIN(PIN_PB14, 1, 1)
#define PIN_PB14__FLEXCOM9_IO1		PINMUX_PIN(PIN_PB14, 2, 1)
#define PIN_PB14__D0			PINMUX_PIN(PIN_PB14, 4, 1)
#define PIN_PB14__PWMH2			PINMUX_PIN(PIN_PB14, 5, 2)
#define PIN_PB15			47
#define PIN_PB15__GPIO			PINMUX_PIN(PIN_PB15, 0, 0)
#define PIN_PB15__QSPI0_SCKN		PINMUX_PIN(PIN_PB15, 1, 1)
#define PIN_PB15__FLEXCOM9_IO2		PINMUX_PIN(PIN_PB15, 2, 1)
#define PIN_PB15__D1			PINMUX_PIN(PIN_PB15, 4, 1)
#define PIN_PB15__PWML3			PINMUX_PIN(PIN_PB15, 5, 2)
#define PIN_PB16			48
#define PIN_PB16__GPIO			PINMUX_PIN(PIN_PB16, 0, 0)
#define PIN_PB16__QSPI0_IO4		PINMUX_PIN(PIN_PB16, 1, 1)
#define PIN_PB16__FLEXCOM9_IO3		PINMUX_PIN(PIN_PB16, 2, 1)
#define PIN_PB16__PCK0			PINMUX_PIN(PIN_PB16, 3, 1)
#define PIN_PB16__D2			PINMUX_PIN(PIN_PB16, 4, 1)
#define PIN_PB16__PWMH3			PINMUX_PIN(PIN_PB16, 5, 2)
#define PIN_PB16__EXT_IRQ0		PINMUX_PIN(PIN_PB16, 6, 2)
#define PIN_PB17			49
#define PIN_PB17__GPIO			PINMUX_PIN(PIN_PB17, 0, 0)
#define PIN_PB17__QSPI0_IO5		PINMUX_PIN(PIN_PB17, 1, 1)
#define PIN_PB17__FLEXCOM9_IO4		PINMUX_PIN(PIN_PB17, 2, 1)
#define PIN_PB17__PCK1			PINMUX_PIN(PIN_PB17, 3, 1)
#define PIN_PB17__D3			PINMUX_PIN(PIN_PB17, 4, 1)
#define PIN_PB17__PWMEXTRG0		PINMUX_PIN(PIN_PB17, 5, 2)
#define PIN_PB17__EXT_IRQ1		PINMUX_PIN(PIN_PB17, 6, 2)
#define PIN_PB18			50
#define PIN_PB18__GPIO			PINMUX_PIN(PIN_PB18, 0, 0)
#define PIN_PB18__QSPI0_IO6		PINMUX_PIN(PIN_PB18, 1, 1)
#define PIN_PB18__FLEXCOM10_IO0		PINMUX_PIN(PIN_PB18, 2, 1)
#define PIN_PB18__PCK2			PINMUX_PIN(PIN_PB18, 3, 1)
#define PIN_PB18__D4			PINMUX_PIN(PIN_PB18, 4, 1)
#define PIN_PB18__PWMEXTRG1		PINMUX_PIN(PIN_PB18, 5, 2)
#define PIN_PB19			51
#define PIN_PB19__GPIO			PINMUX_PIN(PIN_PB19, 0, 0)
#define PIN_PB19__QSPI0_IO7		PINMUX_PIN(PIN_PB19, 1, 1)
#define PIN_PB19__FLEXCOM10_IO1		PINMUX_PIN(PIN_PB19, 2, 1)
#define PIN_PB19__PCK3			PINMUX_PIN(PIN_PB19, 3, 1)
#define PIN_PB19__D5			PINMUX_PIN(PIN_PB19, 4, 1)
#define PIN_PB19__PWMFI0		PINMUX_PIN(PIN_PB19, 5, 2)
#define PIN_PB20			52
#define PIN_PB20__GPIO			PINMUX_PIN(PIN_PB20, 0, 0)
#define PIN_PB20__QSPI0_DQS		PINMUX_PIN(PIN_PB20, 1, 1)
#define PIN_PB20__FLEXCOM10_IO2		PINMUX_PIN(PIN_PB20, 2, 1)
#define PIN_PB20__D6			PINMUX_PIN(PIN_PB20, 4, 1)
#define PIN_PB20__PWMFI1		PINMUX_PIN(PIN_PB20, 5, 2)
#define PIN_PB21			53
#define PIN_PB21__GPIO			PINMUX_PIN(PIN_PB21, 0, 0)
#define PIN_PB21__QSPI0_INT		PINMUX_PIN(PIN_PB21, 1, 1)
#define PIN_PB21__FLEXCOM10_IO3		PINMUX_PIN(PIN_PB21, 2, 1)
#define PIN_PB21__FLEXCOM9_IO5		PINMUX_PIN(PIN_PB21, 3, 1)
#define PIN_PB21__D7			PINMUX_PIN(PIN_PB21, 4, 1)
#define PIN_PB22			54
#define PIN_PB22__GPIO			PINMUX_PIN(PIN_PB22, 0, 0)
#define PIN_PB22__QSPI1_IO3		PINMUX_PIN(PIN_PB22, 1, 1)
#define PIN_PB22__FLEXCOM10_IO4		PINMUX_PIN(PIN_PB22, 2, 1)
#define PIN_PB22__FLEXCOM9_IO6		PINMUX_PIN(PIN_PB22, 3, 1)
#define PIN_PB22__NANDRDY		PINMUX_PIN(PIN_PB22, 4, 1)
#define PIN_PB23			55
#define PIN_PB23__GPIO			PINMUX_PIN(PIN_PB23, 0, 0)
#define PIN_PB23__QSPI1_IO2		PINMUX_PIN(PIN_PB23, 1, 1)
#define PIN_PB23__FLEXCOM7_IO0		PINMUX_PIN(PIN_PB23, 2, 1)
#define PIN_PB23__I2SMCC0_CK		PINMUX_PIN(PIN_PB23, 3, 1)
#define PIN_PB23__PCK4			PINMUX_PIN(PIN_PB23, 6, 1)
#define PIN_PB24			56
#define PIN_PB24__GPIO			PINMUX_PIN(PIN_PB24, 0, 0)
#define PIN_PB24__QSPI1_IO1		PINMUX_PIN(PIN_PB24, 1, 1)
#define PIN_PB24__FLEXCOM7_IO1		PINMUX_PIN(PIN_PB24, 2, 1)
#define PIN_PB24__I2SMCC0_WS		PINMUX_PIN(PIN_PB24, 3, 1)
#define PIN_PB24__PCK5			PINMUX_PIN(PIN_PB24, 6, 1)
#define PIN_PB25			57
#define PIN_PB25__GPIO			PINMUX_PIN(PIN_PB25, 0, 0)
#define PIN_PB25__QSPI1_IO0		PINMUX_PIN(PIN_PB25, 1, 1)
#define PIN_PB25__FLEXCOM7_IO2		PINMUX_PIN(PIN_PB25, 2, 1)
#define PIN_PB25__I2SMCC0_DOUT1		PINMUX_PIN(PIN_PB25, 3, 1)
#define PIN_PB25__PCK6			PINMUX_PIN(PIN_PB25, 6, 1)
#define PIN_PB26			58
#define PIN_PB26__GPIO			PINMUX_PIN(PIN_PB26, 0, 0)
#define PIN_PB26__QSPI1_CS		PINMUX_PIN(PIN_PB26, 1, 1)
#define PIN_PB26__FLEXCOM7_IO3		PINMUX_PIN(PIN_PB26, 2, 1)
#define PIN_PB26__I2SMCC0_DOUT0		PINMUX_PIN(PIN_PB26, 3, 1)
#define PIN_PB26__PWMEXTRG0		PINMUX_PIN(PIN_PB26, 5, 1)
#define PIN_PB26__PCK7			PINMUX_PIN(PIN_PB26, 6, 1)
#define PIN_PB27			59
#define PIN_PB27__GPIO			PINMUX_PIN(PIN_PB27, 0, 0)
#define PIN_PB27__QSPI1_SCK		PINMUX_PIN(PIN_PB27, 1, 1)
#define PIN_PB27__FLEXCOM7_IO4		PINMUX_PIN(PIN_PB27, 2, 1)
#define PIN_PB27__I2SMCC0_MCK		PINMUX_PIN(PIN_PB27, 3, 1)
#define PIN_PB27__PWMEXTRG1		PINMUX_PIN(PIN_PB27, 5, 1)
#define PIN_PB28			60
#define PIN_PB28__GPIO			PINMUX_PIN(PIN_PB28, 0, 0)
#define PIN_PB28__SDMMC1_RSTN		PINMUX_PIN(PIN_PB28, 1, 1)
#define PIN_PB28__ADTRG			PINMUX_PIN(PIN_PB28, 2, 2)
#define PIN_PB28__PWMFI0		PINMUX_PIN(PIN_PB28, 5, 1)
#define PIN_PB28__FLEXCOM7_IO0		PINMUX_PIN(PIN_PB28, 6, 4)
#define PIN_PB29			61
#define PIN_PB29__GPIO			PINMUX_PIN(PIN_PB29, 0, 0)
#define PIN_PB29__SDMMC1_CMD		PINMUX_PIN(PIN_PB29, 1, 1)
#define PIN_PB29__FLEXCOM3_IO2		PINMUX_PIN(PIN_PB29, 2, 2)
#define PIN_PB29__FLEXCOM0_IO5		PINMUX_PIN(PIN_PB29, 3, 2)
#define PIN_PB29__TIOA3			PINMUX_PIN(PIN_PB29, 4, 2)
#define PIN_PB29__PWMFI1		PINMUX_PIN(PIN_PB29, 5, 1)
#define PIN_PB29__FLEXCOM7_IO1		PINMUX_PIN(PIN_PB29, 6, 4)
#define PIN_PB30			62
#define PIN_PB30__GPIO			PINMUX_PIN(PIN_PB30, 0, 0)
#define PIN_PB30__SDMMC1_CK		PINMUX_PIN(PIN_PB30, 1, 1)
#define PIN_PB30__FLEXCOM3_IO3		PINMUX_PIN(PIN_PB30, 2, 2)
#define PIN_PB30__FLEXCOM0_IO6		PINMUX_PIN(PIN_PB30, 3, 2)
#define PIN_PB30__TIOB3			PINMUX_PIN(PIN_PB30, 4, 1)
#define PIN_PB30__PWMH0			PINMUX_PIN(PIN_PB30, 5, 1)
#define PIN_PB30__FLEXCOM8_IO0		PINMUX_PIN(PIN_PB30, 6, 4)
#define PIN_PB31			63
#define PIN_PB31__GPIO			PINMUX_PIN(PIN_PB31, 0, 0)
#define PIN_PB31__SDMMC1_DAT0		PINMUX_PIN(PIN_PB31, 1, 1)
#define PIN_PB31__FLEXCOM3_IO4		PINMUX_PIN(PIN_PB31, 2, 2)
#define PIN_PB31__FLEXCOM9_IO5		PINMUX_PIN(PIN_PB31, 3, 2)
#define PIN_PB31__TCLK3			PINMUX_PIN(PIN_PB31, 4, 1)
#define PIN_PB31__PWML0			PINMUX_PIN(PIN_PB31, 5, 1)
#define PIN_PB31__FLEXCOM8_IO1		PINMUX_PIN(PIN_PB31, 6, 4)
#define PIN_PC0				64
#define PIN_PC0__GPIO			PINMUX_PIN(PIN_PC0, 0, 0)
#define PIN_PC0__SDMMC1_DAT1		PINMUX_PIN(PIN_PC0, 1, 1)
#define PIN_PC0__FLEXCOM3_IO0		PINMUX_PIN(PIN_PC0, 2, 2)
#define PIN_PC0__TIOA4			PINMUX_PIN(PIN_PC0, 4, 1)
#define PIN_PC0__PWML1			PINMUX_PIN(PIN_PC0, 5, 1)
#define PIN_PC0__FLEXCOM9_IO0		PINMUX_PIN(PIN_PC0, 6, 4)
#define PIN_PC1				65
#define PIN_PC1__GPIO			PINMUX_PIN(PIN_PC1, 0, 0)
#define PIN_PC1__SDMMC1_DAT2		PINMUX_PIN(PIN_PC1, 1, 1)
#define PIN_PC1__FLEXCOM3_IO1		PINMUX_PIN(PIN_PC1, 2, 2)
#define PIN_PC1__TIOB4			PINMUX_PIN(PIN_PC1, 4, 1)
#define PIN_PC1__PWMH1			PINMUX_PIN(PIN_PC1, 5, 1)
#define PIN_PC1__FLEXCOM9_IO1		PINMUX_PIN(PIN_PC1, 6, 4)
#define PIN_PC2				66
#define PIN_PC2__GPIO			PINMUX_PIN(PIN_PC2, 0, 0)
#define PIN_PC2__SDMMC1_DAT3		PINMUX_PIN(PIN_PC2, 1, 1)
#define PIN_PC2__FLEXCOM4_IO0		PINMUX_PIN(PIN_PC2, 2, 2)
#define PIN_PC2__TCLK4			PINMUX_PIN(PIN_PC2, 4, 1)
#define PIN_PC2__PWML2			PINMUX_PIN(PIN_PC2, 5, 1)
#define PIN_PC2__FLEXCOM10_IO0		PINMUX_PIN(PIN_PC2, 6, 4)
#define PIN_PC3				67
#define PIN_PC3__GPIO			PINMUX_PIN(PIN_PC3, 0, 0)
#define PIN_PC3__SDMMC1_WP		PINMUX_PIN(PIN_PC3, 1, 1)
#define PIN_PC3__FLEXCOM4_IO1		PINMUX_PIN(PIN_PC3, 2, 2)
#define PIN_PC3__TIOA5			PINMUX_PIN(PIN_PC3, 4, 1)
#define PIN_PC3__PWMH2			PINMUX_PIN(PIN_PC3, 5, 1)
#define PIN_PC3__FLEXCOM10_IO1		PINMUX_PIN(PIN_PC3, 6, 4)
#define PIN_PC4				68
#define PIN_PC4__GPIO			PINMUX_PIN(PIN_PC4, 0, 0)
#define PIN_PC4__SDMMC1_CD		PINMUX_PIN(PIN_PC4, 1, 1)
#define PIN_PC4__FLEXCOM4_IO2		PINMUX_PIN(PIN_PC4, 2, 2)
#define PIN_PC4__FLEXCOM9_IO6		PINMUX_PIN(PIN_PC4, 3, 2)
#define PIN_PC4__TIOB5			PINMUX_PIN(PIN_PC4, 4, 1)
#define PIN_PC4__PWML3			PINMUX_PIN(PIN_PC4, 5, 1)
#define PIN_PC4__FLEXCOM11_IO0		PINMUX_PIN(PIN_PC4, 6, 4)
#define PIN_PC5				69
#define PIN_PC5__GPIO			PINMUX_PIN(PIN_PC5, 0, 0)
#define PIN_PC5__SDMMC1_1V8SEL		PINMUX_PIN(PIN_PC5, 1, 1)
#define PIN_PC5__FLEXCOM4_IO3		PINMUX_PIN(PIN_PC5, 2, 2)
#define PIN_PC5__FLEXCOM6_IO5		PINMUX_PIN(PIN_PC5, 3, 2)
#define PIN_PC5__TCLK5			PINMUX_PIN(PIN_PC5, 4, 1)
#define PIN_PC5__PWMH3			PINMUX_PIN(PIN_PC5, 5, 1)
#define PIN_PC5__FLEXCOM11_IO1		PINMUX_PIN(PIN_PC5, 6, 4)
#define PIN_PC6				70
#define PIN_PC6__GPIO			PINMUX_PIN(PIN_PC6, 0, 0)
#define PIN_PC6__FLEXCOM4_IO4		PINMUX_PIN(PIN_PC6, 2, 2)
#define PIN_PC6__FLEXCOM6_IO6		PINMUX_PIN(PIN_PC6, 3, 2)
#define PIN_PC7				71
#define PIN_PC7__GPIO			PINMUX_PIN(PIN_PC7, 0, 0)
#define PIN_PC7__I2SMCC0_DIN0		PINMUX_PIN(PIN_PC7, 1, 1)
#define PIN_PC7__FLEXCOM7_IO0		PINMUX_PIN(PIN_PC7, 2, 2)
#define PIN_PC8				72
#define PIN_PC8__GPIO			PINMUX_PIN(PIN_PC8, 0, 0)
#define PIN_PC8__I2SMCC0_DIN1		PINMUX_PIN(PIN_PC8, 1, 1)
#define PIN_PC8__FLEXCOM7_IO1		PINMUX_PIN(PIN_PC8, 2, 2)
#define PIN_PC9				73
#define PIN_PC9__GPIO			PINMUX_PIN(PIN_PC9, 0, 0)
#define PIN_PC9__I2SMCC0_DOUT3		PINMUX_PIN(PIN_PC9, 1, 1)
#define PIN_PC9__FLEXCOM7_IO2		PINMUX_PIN(PIN_PC9, 2, 2)
#define PIN_PC9__FLEXCOM1_IO0		PINMUX_PIN(PIN_PC9, 6, 4)
#define PIN_PC10			74
#define PIN_PC10__GPIO			PINMUX_PIN(PIN_PC10, 0, 0)
#define PIN_PC10__I2SMCC0_DOUT2		PINMUX_PIN(PIN_PC10, 1, 1)
#define PIN_PC10__FLEXCOM7_IO3		PINMUX_PIN(PIN_PC10, 2, 2)
#define PIN_PC10__FLEXCOM1_IO1		PINMUX_PIN(PIN_PC10, 6, 4)
#define PIN_PC11			75
#define PIN_PC11__GPIO			PINMUX_PIN(PIN_PC11, 0, 0)
#define PIN_PC11__I2SMCC1_CK		PINMUX_PIN(PIN_PC11, 1, 1)
#define PIN_PC11__FLEXCOM7_IO4		PINMUX_PIN(PIN_PC11, 2, 2)
#define PIN_PC11__FLEXCOM2_IO0		PINMUX_PIN(PIN_PC11, 6, 4)
#define PIN_PC12			76
#define PIN_PC12__GPIO			PINMUX_PIN(PIN_PC12, 0, 0)
#define PIN_PC12__I2SMCC1_WS		PINMUX_PIN(PIN_PC12, 1, 1)
#define PIN_PC12__FLEXCOM8_IO2		PINMUX_PIN(PIN_PC12, 2, 2)
#define PIN_PC12__FLEXCOM2_IO1		PINMUX_PIN(PIN_PC12, 6, 4)
#define PIN_PC13			77
#define PIN_PC13__GPIO			PINMUX_PIN(PIN_PC13, 0, 0)
#define PIN_PC13__I2SMCC1_MCK		PINMUX_PIN(PIN_PC13, 1, 1)
#define PIN_PC13__FLEXCOM8_IO1		PINMUX_PIN(PIN_PC13, 2, 2)
#define PIN_PC13__FLEXCOM3_IO0		PINMUX_PIN(PIN_PC13, 6, 4)
#define PIN_PC14			78
#define PIN_PC14__GPIO			PINMUX_PIN(PIN_PC14, 0, 0)
#define PIN_PC14__I2SMCC1_DOUT0		PINMUX_PIN(PIN_PC14, 1, 1)
#define PIN_PC14__FLEXCOM8_IO0		PINMUX_PIN(PIN_PC14, 2, 2)
#define PIN_PC14__FLEXCOM3_IO1		PINMUX_PIN(PIN_PC14, 6, 4)
#define PIN_PC15			79
#define PIN_PC15__GPIO			PINMUX_PIN(PIN_PC15, 0, 0)
#define PIN_PC15__I2SMCC1_DOUT1		PINMUX_PIN(PIN_PC15, 1, 1)
#define PIN_PC15__FLEXCOM8_IO3		PINMUX_PIN(PIN_PC15, 2, 2)
#define PIN_PC15__FLEXCOM4_IO0		PINMUX_PIN(PIN_PC15, 6, 4)
#define PIN_PC16			80
#define PIN_PC16__GPIO			PINMUX_PIN(PIN_PC16, 0, 0)
#define PIN_PC16__I2SMCC_DOUT2		PINMUX_PIN(PIN_PC16, 1, 1)
#define PIN_PC16__FLEXCOM8_IO4		PINMUX_PIN(PIN_PC16, 2, 2)
#define PIN_PC16__FLEXCOM3_IO1		PINMUX_PIN(PIN_PC16, 6, 4)
#define PIN_PC17			81
#define PIN_PC17__GPIO			PINMUX_PIN(PIN_PC17, 0, 0)
#define PIN_PC17__I2SMCC1_DOUT3		PINMUX_PIN(PIN_PC17, 1, 1)
#define PIN_PC17__EXT_IRQ0		PINMUX_PIN(PIN_PC17, 2, 3)
#define PIN_PC17__FLEXCOM5_IO0		PINMUX_PIN(PIN_PC17, 6, 4)
#define PIN_PC18			82
#define PIN_PC18__GPIO			PINMUX_PIN(PIN_PC18, 0, 0)
#define PIN_PC18__I2SMCC1_DIN0		PINMUX_PIN(PIN_PC18, 1, 1)
#define PIN_PC18__FLEXCOM9_IO0		PINMUX_PIN(PIN_PC18, 2, 2)
#define PIN_PC18__FLEXCOM5_IO1		PINMUX_PIN(PIN_PC18, 6, 4)
#define PIN_PC19			83
#define PIN_PC19__GPIO			PINMUX_PIN(PIN_PC19, 0, 0)
#define PIN_PC19__I2SMCC1_DIN1		PINMUX_PIN(PIN_PC19, 1, 1)
#define PIN_PC19__FLEXCOM9_IO1		PINMUX_PIN(PIN_PC19, 2, 2)
#define PIN_PC19__FLEXCOM6_IO0		PINMUX_PIN(PIN_PC19, 6, 4)
#define PIN_PC20			84
#define PIN_PC20__GPIO			PINMUX_PIN(PIN_PC20, 0, 0)
#define PIN_PC20__I2SMCC1_DIN2		PINMUX_PIN(PIN_PC20, 1, 1)
#define PIN_PC20__FLEXCOM9_IO4		PINMUX_PIN(PIN_PC20, 2, 2)
#define PIN_PC20__FLEXCOM6_IO1		PINMUX_PIN(PIN_PC20, 6, 4)
#define PIN_PC21			85
#define PIN_PC21__GPIO			PINMUX_PIN(PIN_PC21, 0, 0)
#define PIN_PC21__I2SMCC1_DIN3		PINMUX_PIN(PIN_PC21, 1, 1)
#define PIN_PC21__FLEXCOM9_IO2		PINMUX_PIN(PIN_PC21, 2, 2)
#define PIN_PC21__D3			PINMUX_PIN(PIN_PC21, 4, 2)
#define PIN_PC21__FLEXCOM6_IO0		PINMUX_PIN(PIN_PC21, 6, 5)
#define PIN_PC22			86
#define PIN_PC22__GPIO			PINMUX_PIN(PIN_PC22, 0, 0)
#define PIN_PC22__I2SMCC0_DIN2		PINMUX_PIN(PIN_PC22, 1, 1)
#define PIN_PC22__FLEXCOM9_IO3		PINMUX_PIN(PIN_PC22, 2, 2)
#define PIN_PC22__D4			PINMUX_PIN(PIN_PC22, 4, 2)
#define PIN_PC22__FLEXCOM6_IO1		PINMUX_PIN(PIN_PC22, 6, 5)
#define PIN_PC23			87
#define PIN_PC23__GPIO			PINMUX_PIN(PIN_PC23, 0, 0)
#define PIN_PC23__I2SMCC0_DIN3		PINMUX_PIN(PIN_PC23, 1, 1)
#define PIN_PC23__FLEXCOM0_IO5		PINMUX_PIN(PIN_PC23, 2, 3)
#define PIN_PC23__D5			PINMUX_PIN(PIN_PC23, 4, 2)
#define PIN_PC23__FLEXCOM7_IO0		PINMUX_PIN(PIN_PC23, 6, 5)
#define PIN_PC24			88
#define PIN_PC24__GPIO			PINMUX_PIN(PIN_PC24, 0, 0)
#define PIN_PC24__FLEXCOM0_IO6		PINMUX_PIN(PIN_PC24, 2, 3)
#define PIN_PC24__EXT_IRQ1		PINMUX_PIN(PIN_PC24, 3, 3)
#define PIN_PC24__D6			PINMUX_PIN(PIN_PC24, 4, 2)
#define PIN_PC24__FLEXCOM7_IO1		PINMUX_PIN(PIN_PC24, 6, 5)
#define PIN_PC25			89
#define PIN_PC25__GPIO			PINMUX_PIN(PIN_PC25, 0, 0)
#define PIN_PC25__NTRST			PINMUX_PIN(PIN_PC25, 1, 1)
#define PIN_PC26			90
#define PIN_PC26__GPIO			PINMUX_PIN(PIN_PC26, 0, 0)
#define PIN_PC26__TCK_SWCLK		PINMUX_PIN(PIN_PC26, 1, 1)
#define PIN_PC27			91
#define PIN_PC27__GPIO			PINMUX_PIN(PIN_PC27, 0, 0)
#define PIN_PC27__TMS_SWDIO		PINMUX_PIN(PIN_PC27, 1, 1)
#define PIN_PC28			92
#define PIN_PC28__GPIO			PINMUX_PIN(PIN_PC28, 0, 0)
#define PIN_PC28__TDI			PINMUX_PIN(PIN_PC28, 1, 1)
#define PIN_PC29			93
#define PIN_PC29__GPIO			PINMUX_PIN(PIN_PC29, 0, 0)
#define PIN_PC29__TDO			PINMUX_PIN(PIN_PC29, 1, 1)
#define PIN_PC30			94
#define PIN_PC30__GPIO			PINMUX_PIN(PIN_PC30, 0, 0)
#define PIN_PC30__FLEXCOM10_IO0		PINMUX_PIN(PIN_PC30, 2, 2)
#define PIN_PC31			95
#define PIN_PC31__GPIO			PINMUX_PIN(PIN_PC31, 0, 0)
#define PIN_PC31__FLEXCOM10_IO1		PINMUX_PIN(PIN_PC31, 2, 2)
#define PIN_PD0				96
#define PIN_PD0__GPIO			PINMUX_PIN(PIN_PD0, 0, 0)
#define PIN_PD0__FLEXCOM11_IO0		PINMUX_PIN(PIN_PD0, 2, 2)
#define PIN_PD1				97
#define PIN_PD1__GPIO			PINMUX_PIN(PIN_PD1, 0, 0)
#define PIN_PD1__FLEXCOM11_IO1		PINMUX_PIN(PIN_PD1, 2, 2)
#define PIN_PD2				98
#define PIN_PD2__GPIO			PINMUX_PIN(PIN_PD2, 0, 0)
#define PIN_PD2__SDMMC2_RSTN		PINMUX_PIN(PIN_PD2, 1, 1)
#define PIN_PD2__PCK0			PINMUX_PIN(PIN_PD2, 2, 2)
#define PIN_PD2__CANTX4			PINMUX_PIN(PIN_PD2, 3, 1)
#define PIN_PD2__D7			PINMUX_PIN(PIN_PD2, 4, 2)
#define PIN_PD2__TIOA0			PINMUX_PIN(PIN_PD2, 5, 2)
#define PIN_PD2__FLEXCOM8_IO0		PINMUX_PIN(PIN_PD2, 6, 5)
#define PIN_PD3				99
#define PIN_PD3__GPIO			PINMUX_PIN(PIN_PD3, 0, 0)
#define PIN_PD3__SDMMC2_CMD		PINMUX_PIN(PIN_PD3, 1, 1)
#define PIN_PD3__FLEXCOM0_IO0		PINMUX_PIN(PIN_PD3, 2, 2)
#define PIN_PD3__CANRX4			PINMUX_PIN(PIN_PD3, 3, 1)
#define PIN_PD3__NANDRDY		PINMUX_PIN(PIN_PD3, 4, 2)
#define PIN_PD3__TIOB0			PINMUX_PIN(PIN_PD3, 5, 2)
#define PIN_PD3__FLEXCOM8_IO1		PINMUX_PIN(PIN_PD3, 6, 5)
#define PIN_PD4				100
#define PIN_PD4__GPIO			PINMUX_PIN(PIN_PD4, 0, 0)
#define PIN_PD4__SDMMC2_CK		PINMUX_PIN(PIN_PD4, 1, 1)
#define PIN_PD4__FLEXCOM0_IO1		PINMUX_PIN(PIN_PD4, 2, 2)
#define PIN_PD4__CANTX5			PINMUX_PIN(PIN_PD4, 3, 1)
#define PIN_PD4__NCS3_NANDCS		PINMUX_PIN(PIN_PD4, 4, 2)
#define PIN_PD4__TCLK0			PINMUX_PIN(PIN_PD4, 5, 2)
#define PIN_PD4__FLEXCOM9_IO0		PINMUX_PIN(PIN_PD4, 6, 5)
#define PIN_PD5				101
#define PIN_PD5__GPIO			PINMUX_PIN(PIN_PD5, 0, 0)
#define PIN_PD5__SDMMC2_DAT0		PINMUX_PIN(PIN_PD5, 1, 1)
#define PIN_PD5__FLEXCOM0_IO2		PINMUX_PIN(PIN_PD5, 2, 2)
#define PIN_PD5__CANRX5			PINMUX_PIN(PIN_PD5, 3, 1)
#define PIN_PD5__NWE_NWR0_NANDWE	PINMUX_PIN(PIN_PD5, 4, 2)
#define PIN_PD5__TIOA1			PINMUX_PIN(PIN_PD5, 5, 2)
#define PIN_PD5__FLEXCOM9_IO1		PINMUX_PIN(PIN_PD5, 6, 5)
#define PIN_PD6				102
#define PIN_PD6__GPIO			PINMUX_PIN(PIN_PD6, 0, 0)
#define PIN_PD6__SDMMC2_DAT1		PINMUX_PIN(PIN_PD6, 1, 1)
#define PIN_PD6__FLEXCOM0_IO3		PINMUX_PIN(PIN_PD6, 2, 2)
#define PIN_PD6__SPDIF_RX		PINMUX_PIN(PIN_PD6, 3, 3)
#define PIN_PD6__NRD_NANDOE		PINMUX_PIN(PIN_PD6, 4, 2)
#define PIN_PD6__TIOB1			PINMUX_PIN(PIN_PD6, 5, 2)
#define PIN_PD6__FLEXCOM10_IO0		PINMUX_PIN(PIN_PD6, 6, 5)
#define PIN_PD7				103
#define PIN_PD7__GPIO			PINMUX_PIN(PIN_PD7, 0, 0)
#define PIN_PD7__SDMMC2_DAT2		PINMUX_PIN(PIN_PD7, 1, 1)
#define PIN_PD7__FLEXCOM0_IO4		PINMUX_PIN(PIN_PD7, 2, 2)
#define PIN_PD7__SPDIF_TX		PINMUX_PIN(PIN_PD7, 2, 2)
#define PIN_PD7__A21_NANDALE		PINMUX_PIN(PIN_PD7, 4, 2)
#define PIN_PD7__TCLK1			PINMUX_PIN(PIN_PD7, 5, 2)
#define PIN_PD7__FLEXCOM10_IO1		PINMUX_PIN(PIN_PD7, 6, 5)
#define PIN_PD8				104
#define PIN_PD8__GPIO			PINMUX_PIN(PIN_PD8, 0, 0)
#define PIN_PD8__SDMMC2_DAT3		PINMUX_PIN(PIN_PD8, 1, 1)
#define PIN_PD8__I2SMCC0_DIN0		PINMUX_PIN(PIN_PD8, 3, 1)
#define PIN_PD8__A11_NANDCLE		PINMUX_PIN(PIN_PD8, 4, 2)
#define PIN_PD8__TIOA2			PINMUX_PIN(PIN_PD8, 5, 2)
#define PIN_PD8__FLEXCOM11_IO0		PINMUX_PIN(PIN_PD8, 6, 5)
#define PIN_PD9				105
#define PIN_PD9__GPIO			PINMUX_PIN(PIN_PD9, 0, 0)
#define PIN_PD9__SDMMC2_WP		PINMUX_PIN(PIN_PD9, 1, 1)
#define PIN_PD9__I2SMCC0_DIN1		PINMUX_PIN(PIN_PD9, 3, 2)
#define PIN_PD9__D0			PINMUX_PIN(PIN_PD9, 4, 2)
#define PIN_PD9__TIOB2			PINMUX_PIN(PIN_PD9, 5, 2)
#define PIN_PD9__FLEXCOM11_IO1		PINMUX_PIN(PIN_PD9, 6, 5)
#define PIN_PD10			106
#define PIN_PD10__GPIO			PINMUX_PIN(PIN_PD10, 0, 0)
#define PIN_PD10__SDMMC2_CD		PINMUX_PIN(PIN_PD10, 1, 1)
#define PIN_PD10__PCK6			PINMUX_PIN(PIN_PD10, 2, 2)
#define PIN_PD10__I2SMCC0_DIN2		PINMUX_PIN(PIN_PD10, 3, 2)
#define PIN_PD10__D1			PINMUX_PIN(PIN_PD10, 4, 2)
#define PIN_PD10__TCLK2			PINMUX_PIN(PIN_PD10, 5, 2)
#define PIN_PD10__FLEXCOM0_IO0		PINMUX_PIN(PIN_PD10, 6, 3)
#define PIN_PD11			107
#define PIN_PD11__GPIO			PINMUX_PIN(PIN_PD11, 0, 0)
#define PIN_PD11__SDMMC2_1V8SEL		PINMUX_PIN(PIN_PD11, 1, 1)
#define PIN_PD11__PCK7			PINMUX_PIN(PIN_PD11, 2, 2)
#define PIN_PD11__I2SMCC0_DIN3		PINMUX_PIN(PIN_PD11, 3, 2)
#define PIN_PD11__D2			PINMUX_PIN(PIN_PD11, 4, 2)
#define PIN_PD11__TIOA3			PINMUX_PIN(PIN_PD11, 5, 2)
#define PIN_PD11__FLEXCOM0_IO1		PINMUX_PIN(PIN_PD11, 6, 3)
#define PIN_PD12			108
#define PIN_PD12__GPIO			PINMUX_PIN(PIN_PD12, 0, 0)
#define PIN_PD12__PCK1			PINMUX_PIN(PIN_PD12, 1, 2)
#define PIN_PD12__FLEXCOM1_IO0		PINMUX_PIN(PIN_PD12, 2, 2)
#define PIN_PD12__CANTX0		PINMUX_PIN(PIN_PD12, 4, 2)
#define PIN_PD12__TIOB3			PINMUX_PIN(PIN_PD12, 5, 2)
#define PIN_PD13			109
#define PIN_PD13__GPIO			PINMUX_PIN(PIN_PD13, 0, 0)
#define PIN_PD13__I2SMCC0_CK		PINMUX_PIN(PIN_PD13, 1, 2)
#define PIN_PD13__FLEXCOM1_IO1		PINMUX_PIN(PIN_PD13, 2, 2)
#define PIN_PD13__PWML0			PINMUX_PIN(PIN_PD13, 3, 4)
#define PIN_PD13__CANRX0		PINMUX_PIN(PIN_PD13, 4, 2)
#define PIN_PD13__TCLK3			PINMUX_PIN(PIN_PD13, 5, 2)
#define PIN_PD14			110
#define PIN_PD14__GPIO			PINMUX_PIN(PIN_PD14, 0, 0)
#define PIN_PD14__I2SMCC0_MCK		PINMUX_PIN(PIN_PD14, 1, 2)
#define PIN_PD14__FLEXCOM1_IO2		PINMUX_PIN(PIN_PD14, 2, 2)
#define PIN_PD14__PWMH0			PINMUX_PIN(PIN_PD14, 3, 4)
#define PIN_PD14__CANTX1		PINMUX_PIN(PIN_PD14, 4, 2)
#define PIN_PD14__TIOA4			PINMUX_PIN(PIN_PD14, 5, 2)
#define PIN_PD14__FLEXCOM2_IO0		PINMUX_PIN(PIN_PD14, 6, 5)
#define PIN_PD15			111
#define PIN_PD15__GPIO			PINMUX_PIN(PIN_PD15, 0, 0)
#define PIN_PD15__I2SMCC0_WS		PINMUX_PIN(PIN_PD15, 1, 2)
#define PIN_PD15__FLEXCOM1_IO3		PINMUX_PIN(PIN_PD15, 2, 2)
#define PIN_PD15__PWML1			PINMUX_PIN(PIN_PD15, 3, 4)
#define PIN_PD15__CANRX1		PINMUX_PIN(PIN_PD15, 4, 2)
#define PIN_PD15__TIOB4			PINMUX_PIN(PIN_PD15, 5, 2)
#define PIN_PD15__FLEXCOM2_IO1		PINMUX_PIN(PIN_PD15, 6, 5)
#define PIN_PD16			112
#define PIN_PD16__GPIO			PINMUX_PIN(PIN_PD16, 0, 0)
#define PIN_PD16__I2SMCC0_DOUT0		PINMUX_PIN(PIN_PD16, 1, 2)
#define PIN_PD16__FLEXCOM1_IO4		PINMUX_PIN(PIN_PD16, 2, 2)
#define PIN_PD16__PWMH1			PINMUX_PIN(PIN_PD16, 3, 4)
#define PIN_PD16__CANTX2		PINMUX_PIN(PIN_PD16, 4, 2)
#define PIN_PD16__TCLK4			PINMUX_PIN(PIN_PD16, 5, 2)
#define PIN_PD16__FLEXCOM3_IO0		PINMUX_PIN(PIN_PD16, 6, 5)
#define PIN_PD17			113
#define PIN_PD17__GPIO			PINMUX_PIN(PIN_PD17, 0, 0)
#define PIN_PD17__I2SMCC0_DOUT1		PINMUX_PIN(PIN_PD17, 1, 2)
#define PIN_PD17__FLEXCOM2_IO0		PINMUX_PIN(PIN_PD17, 2, 2)
#define PIN_PD17__PWML2			PINMUX_PIN(PIN_PD17, 3, 4)
#define PIN_PD17__CANRX2		PINMUX_PIN(PIN_PD17, 4, 2)
#define PIN_PD17__TIOA5			PINMUX_PIN(PIN_PD17, 5, 2)
#define PIN_PD17__FLEXCOM3_IO1		PINMUX_PIN(PIN_PD17, 6, 5)
#define PIN_PD18			114
#define PIN_PD18__GPIO			PINMUX_PIN(PIN_PD18, 0, 0)
#define PIN_PD18__I2SMCC0_DOUT2		PINMUX_PIN(PIN_PD18, 1, 2)
#define PIN_PD18__FLEXCOM2_IO1		PINMUX_PIN(PIN_PD18, 2, 2)
#define PIN_PD18__PWMH2			PINMUX_PIN(PIN_PD18, 3, 4)
#define PIN_PD18__CANTX3		PINMUX_PIN(PIN_PD18, 4, 2)
#define PIN_PD18__TIOB5			PINMUX_PIN(PIN_PD18, 5, 2)
#define PIN_PD18__FLEXCOM4_IO0		PINMUX_PIN(PIN_PD18, 6, 5)
#define PIN_PD19			115
#define PIN_PD19__GPIO			PINMUX_PIN(PIN_PD19, 0, 0)
#define PIN_PD19__I2SMCC0_DOUT3		PINMUX_PIN(PIN_PD19, 1, 2)
#define PIN_PD19__FLEXCOM2_IO2		PINMUX_PIN(PIN_PD19, 2, 2)
#define PIN_PD19__PWML3			PINMUX_PIN(PIN_PD19, 3, 4)
#define PIN_PD19__CANRX3		PINMUX_PIN(PIN_PD19, 4, 2)
#define PIN_PD19__TCLK5			PINMUX_PIN(PIN_PD19, 5, 2)
#define PIN_PD19__FLEXCOM4_IO1		PINMUX_PIN(PIN_PD19, 6, 5)
#define PIN_PD20			116
#define PIN_PD20__GPIO			PINMUX_PIN(PIN_PD20, 0, 0)
#define PIN_PD20__PCK0			PINMUX_PIN(PIN_PD20, 1, 3)
#define PIN_PD20__FLEXCOM2_IO3		PINMUX_PIN(PIN_PD20, 2, 2)
#define PIN_PD20__PWMH3			PINMUX_PIN(PIN_PD20, 3, 4)
#define PIN_PD20__CANTX4		PINMUX_PIN(PIN_PD20, 5, 2)
#define PIN_PD20__FLEXCOM5_IO0		PINMUX_PIN(PIN_PD20, 6, 5)
#define PIN_PD21			117
#define PIN_PD21__GPIO			PINMUX_PIN(PIN_PD21, 0, 0)
#define PIN_PD21__PCK1			PINMUX_PIN(PIN_PD21, 1, 3)
#define PIN_PD21__FLEXCOM2_IO4		PINMUX_PIN(PIN_PD21, 2, 2)
#define PIN_PD21__CANRX4		PINMUX_PIN(PIN_PD21, 4, 2)
#define PIN_PD21__FLEXCOM5_IO1		PINMUX_PIN(PIN_PD21, 6, 5)
#define PIN_PD21__G1_TXEN		PINMUX_PIN(PIN_PD21, 7, 1)
#define PIN_PD22			118
#define PIN_PD22__GPIO			PINMUX_PIN(PIN_PD22, 0, 0)
#define PIN_PD22__PDMC0_CLK		PINMUX_PIN(PIN_PD22, 1, 2)
#define PIN_PD22__PWMEXTRG0		PINMUX_PIN(PIN_PD22, 3, 4)
#define PIN_PD22__RD1			PINMUX_PIN(PIN_PD22, 4, 2)
#define PIN_PD22__CANTX5		PINMUX_PIN(PIN_PD22, 6, 2)
#define PIN_PD22__G1_TX0		PINMUX_PIN(PIN_PD22, 7, 1)
#define PIN_PD23			119
#define PIN_PD23__GPIO			PINMUX_PIN(PIN_PD23, 0, 0)
#define PIN_PD23__PDMC0_DS0		PINMUX_PIN(PIN_PD23, 1, 2)
#define PIN_PD23__PWMEXTRG1		PINMUX_PIN(PIN_PD23, 3, 4)
#define PIN_PD23__RF1			PINMUX_PIN(PIN_PD23, 4, 2)
#define PIN_PD23__ISC_MCK		PINMUX_PIN(PIN_PD23, 5, 2)
#define PIN_PD23__CANRX5		PINMUX_PIN(PIN_PD23, 6, 2)
#define PIN_PD23__G1_TX1		PINMUX_PIN(PIN_PD23, 7, 1)
#define PIN_PD24			120
#define PIN_PD24__GPIO			PINMUX_PIN(PIN_PD24, 0, 0)
#define PIN_PD24__PDMC0_DS1		PINMUX_PIN(PIN_PD24, 1, 2)
#define PIN_PD24__PWMFI0		PINMUX_PIN(PIN_PD24, 3, 4)
#define PIN_PD24__RK1			PINMUX_PIN(PIN_PD24, 4, 2)
#define PIN_PD24__ISC_D0		PINMUX_PIN(PIN_PD24, 5, 2)
#define PIN_PD24__G1_RXDV		PINMUX_PIN(PIN_PD24, 7, 1)
#define PIN_PD25			121
#define PIN_PD25__GPIO			PINMUX_PIN(PIN_PD25, 0, 0)
#define PIN_PD25__PDMC1_CLK		PINMUX_PIN(PIN_PD25, 1, 2)
#define PIN_PD25__FLEXCOM5_IO0		PINMUX_PIN(PIN_PD25, 2, 2)
#define PIN_PD25__PWMFI1		PINMUX_PIN(PIN_PD25, 3, 4)
#define PIN_PD25__TD1			PINMUX_PIN(PIN_PD25, 4, 2)
#define PIN_PD25__ISC_D1		PINMUX_PIN(PIN_PD25, 5, 2)
#define PIN_PD25__G1_RX0		PINMUX_PIN(PIN_PD25, 7, 1)
#define PIN_PD26			122
#define PIN_PD26__GPIO			PINMUX_PIN(PIN_PD26, 0, 0)
#define PIN_PD26__PDMC1_DS0		PINMUX_PIN(PIN_PD26, 1, 2)
#define PIN_PD26__FLEXCOM5_IO1		PINMUX_PIN(PIN_PD26, 2, 2)
#define PIN_PD26__ADTRG			PINMUX_PIN(PIN_PD26, 3, 3)
#define PIN_PD26__TF1			PINMUX_PIN(PIN_PD26, 4, 2)
#define PIN_PD26__ISC_D2		PINMUX_PIN(PIN_PD26, 5, 2)
#define PIN_PD26__G1_RX1		PINMUX_PIN(PIN_PD26, 7, 1)
#define PIN_PD27			123
#define PIN_PD27__GPIO			PINMUX_PIN(PIN_PD27, 0, 0)
#define PIN_PD27__PDMC1_DS1		PINMUX_PIN(PIN_PD27, 1, 2)
#define PIN_PD27__FLEXCOM5_IO2		PINMUX_PIN(PIN_PD27, 2, 2)
#define PIN_PD27__TIOA0			PINMUX_PIN(PIN_PD27, 3, 3)
#define PIN_PD27__TK1			PINMUX_PIN(PIN_PD27, 4, 2)
#define PIN_PD27__ISC_D3		PINMUX_PIN(PIN_PD27, 5, 2)
#define PIN_PD27__G1_RXER		PINMUX_PIN(PIN_PD27, 7, 1)
#define PIN_PD28			124
#define PIN_PD28__GPIO			PINMUX_PIN(PIN_PD28, 0, 0)
#define PIN_PD28__RD0			PINMUX_PIN(PIN_PD28, 1, 2)
#define PIN_PD28__FLEXCOM5_IO3		PINMUX_PIN(PIN_PD28, 2, 2)
#define PIN_PD28__TIOB0			PINMUX_PIN(PIN_PD28, 3, 3)
#define PIN_PD28__I2SMCC1_CK		PINMUX_PIN(PIN_PD28, 4, 2)
#define PIN_PD28__ISC_D4		PINMUX_PIN(PIN_PD28, 5, 2)
#define PIN_PD28__PWML3			PINMUX_PIN(PIN_PD28, 6, 5)
#define PIN_PD28__G1_MDC		PINMUX_PIN(PIN_PD28, 7, 1)
#define PIN_PD29			125
#define PIN_PD29__GPIO			PINMUX_PIN(PIN_PD29, 0, 0)
#define PIN_PD29__RF0			PINMUX_PIN(PIN_PD29, 1, 2)
#define PIN_PD29__FLEXCOM5_IO4		PINMUX_PIN(PIN_PD29, 2, 2)
#define PIN_PD29__TCLK0			PINMUX_PIN(PIN_PD29, 3, 3)
#define PIN_PD29__I2SMCC1_WS		PINMUX_PIN(PIN_PD29, 4, 2)
#define PIN_PD29__ISC_D5		PINMUX_PIN(PIN_PD29, 5, 2)
#define PIN_PD29__PWMH3			PINMUX_PIN(PIN_PD29, 6, 5)
#define PIN_PD29__G1_MDIO		PINMUX_PIN(PIN_PD29, 7, 1)
#define PIN_PD30			126
#define PIN_PD30__GPIO			PINMUX_PIN(PIN_PD30, 0, 0)
#define PIN_PD30__RK0			PINMUX_PIN(PIN_PD30, 1, 2)
#define PIN_PD30__FLEXCOM6_IO0		PINMUX_PIN(PIN_PD30, 2, 2)
#define PIN_PD30__TIOA1			PINMUX_PIN(PIN_PD30, 3, 3)
#define PIN_PD30__I2SMCC1_MCK		PINMUX_PIN(PIN_PD30, 4, 2)
#define PIN_PD30__ISC_D6		PINMUX_PIN(PIN_PD30, 5, 2)
#define PIN_PD30__PWMEXTRG0		PINMUX_PIN(PIN_PD30, 6, 5)
#define PIN_PD30__G1_TXCK		PINMUX_PIN(PIN_PD30, 7, 1)
#define PIN_PD31			127
#define PIN_PD31__GPIO			PINMUX_PIN(PIN_PD31, 0, 0)
#define PIN_PD31__TD0			PINMUX_PIN(PIN_PD31, 1, 2)
#define PIN_PD31__FLEXCOM6_IO1		PINMUX_PIN(PIN_PD31, 2, 2)
#define PIN_PD31__TIOB1			PINMUX_PIN(PIN_PD31, 3, 3)
#define PIN_PD31__I2SMCC1_DOUT0		PINMUX_PIN(PIN_PD31, 4, 2)
#define PIN_PD31__ISC_D7		PINMUX_PIN(PIN_PD31, 5, 2)
#define PIN_PD31__PWM_EXTRG1		PINMUX_PIN(PIN_PD31, 6, 5)
#define PIN_PD31__G1_TX2		PINMUX_PIN(PIN_PD31, 7, 1)
#define PIN_PE0				128
#define PIN_PE0__GPIO			PINMUX_PIN(PIN_PE0, 0, 0)
#define PIN_PE0__TF0			PINMUX_PIN(PIN_PE0, 1, 2)
#define PIN_PE0__FLEXCOM6_IO2		PINMUX_PIN(PIN_PE0, 2, 2)
#define PIN_PE0__TCLK1			PINMUX_PIN(PIN_PE0, 3, 3)
#define PIN_PE0__I2SMCC1_DOUT1		PINMUX_PIN(PIN_PE0, 4, 2)
#define PIN_PE0__ISC_HSYNC		PINMUX_PIN(PIN_PE0, 5, 2)
#define PIN_PE0__PWMFI0			PINMUX_PIN(PIN_PE0, 6, 5)
#define PIN_PE0__G1_TX3			PINMUX_PIN(PIN_PE0, 7, 1)
#define PIN_PE1				129
#define PIN_PE1__GPIO			PINMUX_PIN(PIN_PE1, 0, 0)
#define PIN_PE1__TK0			PINMUX_PIN(PIN_PE1, 1, 2)
#define PIN_PE1__FLEXCOM6_IO3		PINMUX_PIN(PIN_PE1, 2, 2)
#define PIN_PE1__TIOA2			PINMUX_PIN(PIN_PE1, 3, 3)
#define PIN_PE1__I2SMCC1_DOUT2		PINMUX_PIN(PIN_PE1, 4, 2)
#define PIN_PE1__ISC_VSYNC		PINMUX_PIN(PIN_PE1, 5, 2)
#define PIN_PE1__PWMFI1			PINMUX_PIN(PIN_PE1, 6, 5)
#define PIN_PE1__G1_RX2			PINMUX_PIN(PIN_PE1, 7, 1)
#define PIN_PE2				130
#define PIN_PE2__GPIO			PINMUX_PIN(PIN_PE2, 0, 0)
#define PIN_PE2__PWML0			PINMUX_PIN(PIN_PE2, 1, 5)
#define PIN_PE2__FLEXCOM6_IO4		PINMUX_PIN(PIN_PE2, 2, 2)
#define PIN_PE2__TIOB2			PINMUX_PIN(PIN_PE2, 3, 3)
#define PIN_PE2__I2SMCC1_DOUT3		PINMUX_PIN(PIN_PE2, 4, 2)
#define PIN_PE2__ISC_FIELD		PINMUX_PIN(PIN_PE2, 5, 2)
#define PIN_PE2__G1_RX3			PINMUX_PIN(PIN_PE2, 7, 1)
#define PIN_PE3				131
#define PIN_PE3__GPIO			PINMUX_PIN(PIN_PE3, 0, 0)
#define PIN_PE3__PWMH0			PINMUX_PIN(PIN_PE3, 1, 5)
#define PIN_PE3__FLEXCOM0_IO0		PINMUX_PIN(PIN_PE3, 2, 4)
#define PIN_PE3__TCLK2			PINMUX_PIN(PIN_PE3, 3, 3)
#define PIN_PE3__I2SMCC1_DIN0		PINMUX_PIN(PIN_PE3, 4, 2)
#define PIN_PE3__ISC_PCK		PINMUX_PIN(PIN_PE3, 5, 2)
#define PIN_PE3__G1_RXCK		PINMUX_PIN(PIN_PE3, 7, 1)
#define PIN_PE4				132
#define PIN_PE4__GPIO			PINMUX_PIN(PIN_PE4, 0, 0)
#define PIN_PE4__PWML1			PINMUX_PIN(PIN_PE4, 1, 5)
#define PIN_PE4__FLEXCOM0_IO1		PINMUX_PIN(PIN_PE4, 2, 4)
#define PIN_PE4__TIOA3			PINMUX_PIN(PIN_PE4, 3, 3)
#define PIN_PE4__I2SMCC1_DIN1		PINMUX_PIN(PIN_PE4, 4, 2)
#define PIN_PE4__ISC_D8			PINMUX_PIN(PIN_PE4, 5, 2)
#define PIN_PE4__G1_TXER		PINMUX_PIN(PIN_PE4, 7, 1)
#define PIN_PE5				133
#define PIN_PE5__GPIO			PINMUX_PIN(PIN_PE5, 0, 0)
#define PIN_PE5__PWMH1			PINMUX_PIN(PIN_PE5, 1, 5)
#define PIN_PE5__FLEXCOM0_IO2		PINMUX_PIN(PIN_PE5, 2, 4)
#define PIN_PE5__TIOB3			PINMUX_PIN(PIN_PE5, 3, 3)
#define PIN_PE5__I2SMCC1_DIN2		PINMUX_PIN(PIN_PE5, 4, 2)
#define PIN_PE5__ISC_D9			PINMUX_PIN(PIN_PE5, 5, 2)
#define PIN_PE5__G1_COL			PINMUX_PIN(PIN_PE5, 7, 1)
#define PIN_PE6				134
#define PIN_PE6__GPIO			PINMUX_PIN(PIN_PE6, 0, 0)
#define PIN_PE6__PWML2			PINMUX_PIN(PIN_PE6, 1, 5)
#define PIN_PE6__FLEXCOM0_IO3		PINMUX_PIN(PIN_PE6, 2, 4)
#define PIN_PE6__TCLK3			PINMUX_PIN(PIN_PE6, 3, 3)
#define PIN_PE6__I2SMCC1_DIN3		PINMUX_PIN(PIN_PE6, 4, 2)
#define PIN_PE6__ISC_D10		PINMUX_PIN(PIN_PE6, 5, 2)
#define PIN_PE6__G1_CRS			PINMUX_PIN(PIN_PE6, 7, 1)
#define PIN_PE7				135
#define PIN_PE7__GPIO			PINMUX_PIN(PIN_PE7, 0, 0)
#define PIN_PE7__PWMH2			PINMUX_PIN(PIN_PE7, 1, 5)
#define PIN_PE7__FLEXCOM0_IO4		PINMUX_PIN(PIN_PE7, 2, 4)
#define PIN_PE7__TIOA4			PINMUX_PIN(PIN_PE7, 3, 3)
#define PIN_PE7__ISC_D11		PINMUX_PIN(PIN_PE7, 5, 2)
#define PIN_PE7__G1_TSUCOMP		PINMUX_PIN(PIN_PE7, 7, 1)

